/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

class Gold
extends Item {
    int dx;
    int dy;
    Vector goldVector;
    boolean isHiden = true;
    boolean gold = true;

    public Gold(GameDesign gameDesign, byte[][] matrix, byte[][] itemMatrix, LayerManager lm, int sizeMode, Vector goldVector, int dx, int dy) throws IOException {
        super(gameDesign, matrix, itemMatrix, lm, sizeMode);
        this.sprite = new Sprite(gameDesign.getMoney(), 20, 20);
        this.sprite.setFrameSequence(gameDesign.MONEYseq001);
        Random ran = new Random();
        if (ran.nextInt(10) > 5) {
            this.sprite.setFrameSequence(gameDesign.MONEYseq002);
            this.gold = false;
        }
        if (sizeMode == 2) {
            this.feetMove = 18;
            this.sprite.setImage(gameDesign.getMoney18(), 18, 18);
        }
        this.sprite.setPosition(dx * this.feetMove, dy * this.feetMove);
        this.goldVector = goldVector;
        this.dx = dx;
        this.dy = dy;
        lm.insert((Layer)this.sprite, 0);
    }

    public void action(Vector character, MainPlayer player) {
        if (this.matrix[this.dy][this.dx] != 0) {
            this.sprite.setVisible(false);
        } else {
            this.itemMatrix[this.dy][this.dx] = 1;
            this.sprite.setVisible(true);
        }
        if (this.sprite.isVisible()) {
            this.sprite.nextFrame();
            for (int i = 0; i < character.size(); ++i) {
                Character cha = (Character)((Object)character.elementAt(i));
                if (!this.sprite.collidesWith(cha.sprite, true)) continue;
                if (cha.isPlayer) {
                    if (this.gold) {
                        cha.score += 100;
                        player.lostGold = 1;
                        player.lostGoldValue = 100;
                    } else {
                        cha.score += 50;
                        player.lostGold = 2;
                        player.lostGoldValue = 50;
                    }
                } else if (this.gold) {
                    player.score -= 200;
                    player.lostGold = 3;
                    player.lostGoldValue = 200;
                } else {
                    player.score -= 100;
                    player.lostGold = 4;
                    player.lostGoldValue = 100;
                }
                this.sprite.setVisible(false);
                this.itemMatrix[this.dy][this.dx] = 0;
                this.lm.remove((Layer)this.sprite);
                this.isHiden = false;
                break;
            }
        }
    }
}

