/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class HighScoreScreen
extends GameCanvas
implements CommandListener,
Runnable {
    private boolean isPlay = true;
    private long delay = 75L;
    private Thread gameThread = null;
    SunnetCanvas sunnetCanvas;
    Command resetCommand = new Command("Reset", 4, 0);
    Command backCommand = new Command("Back", 2, 0);
    String[] names = new String[3];
    int[] stag = new int[3];
    int[] time = new int[3];
    String[] note;
    boolean isCommand = false;
    int cX;
    int cY;
    Font font = Font.getFont((int)64, (int)1, (int)0);

    public HighScoreScreen(SunnetCanvas sunnetCanvas) throws Exception {
        super(false);
        this.sunnetCanvas = sunnetCanvas;
        this.note = new String[6];
        this.init();
        this.initLang();
        this.addCommand(this.backCommand);
        this.addCommand(this.resetCommand);
        this.setCommandListener(this);
        this.cX = this.getWidth() / 4;
        this.cY = this.getHeight() / 2;
    }

    public void initLang() {
        if (this.sunnetCanvas.midlet.menuLanguage) {
            this.note[0] = "1st Position";
            this.note[1] = "2nd Position";
            this.note[2] = "3th Position";
            this.note[3] = " ";
            this.note[4] = "Stage ";
            this.note[5] = "Time";
        } else {
            this.note[0] = "V\u1ecb tr\u00ed s\u1ed1 1";
            this.note[1] = "V\u1ecb tr\u00ed s\u1ed1 2";
            this.note[2] = "V\u1ecb tr\u00ed s\u1ed1 3";
            this.note[3] = " ";
            this.note[4] = "C\u1eeda ";
            this.note[5] = "S\u1ed1 Gi\u1edd";
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.resetCommand) {
            try {
                BomMidlet cfr_ignored_0 = this.sunnetCanvas.midlet;
                Score score = new Score("BOOM");
                score.loadScores();
                score.reset();
                this.initLang();
                this.init();
                score = null;
                Runtime.getRuntime().gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (c == this.backCommand) {
            try {
                Graphics g = this.getGraphics();
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(255, 0, 0);
                g.setFont(Font.getFont((int)64, (int)1, (int)0));
                g.drawString("NOW LOADING...", this.getWidth() / 2, this.getHeight() / 2, 17);
                this.flushGraphics();
                this.clean(g);
                Thread.sleep(3000L);
                this.sunnetCanvas.midlet.display.setCurrent((Displayable)this.sunnetCanvas);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clean(Graphics g) {
        this.isPlay = false;
        this.gameThread = null;
        this.removeCommand(this.resetCommand);
        this.resetCommand = null;
        this.removeCommand(this.backCommand);
        this.backCommand = null;
        this.stag = null;
        this.names = null;
        this.time = null;
        this.note = null;
        this.font = null;
        g = null;
        Runtime.getRuntime().gc();
    }

    public void init() throws Exception {
        BomMidlet cfr_ignored_0 = this.sunnetCanvas.midlet;
        Score score = new Score("BOOM");
        score.loadScores();
        this.names = score.getNames();
        this.stag = score.stage;
        this.time = score.time;
    }

    public void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    private void drawScreen(Graphics g) {
        int i;
        int len;
        int lenY;
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(255, 0, 0);
        if (this.sunnetCanvas.sizeMode == 2) {
            lenY = 0;
            len = 15;
        } else {
            lenY = 0;
            len = 20;
        }
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        for (i = 0; i < 3; ++i) {
            g.drawString("" + this.note[i], 10, lenY + len * 4 * i, 20);
        }
        g.setColor(0, 255, 0);
        g.setFont(Font.getFont((int)64, (int)0, (int)0));
        for (i = 0; i < 3; ++i) {
            g.drawString("" + this.note[3], 30, lenY + len * (4 * i + 1), 20);
            g.drawString("" + this.note[4], 30, lenY + len * (4 * i + 2), 20);
            g.drawString("" + this.note[5], 30, lenY + len * (4 * i + 3), 20);
        }
        g.setColor(255, 255, 255);
        g.setFont(Font.getFont((int)64, (int)0, (int)8));
        for (i = 0; i < 3; ++i) {
            int h = this.time[i] / 3600;
            int p = (this.time[i] - 3600 * h) / 60;
            int s = this.time[i] - 3600 * h - 60 * p;
            g.drawString(this.names[i], 50, lenY + len * (4 * i + 1) + 3, 20);
            g.drawString(" " + this.stag[i], 90, lenY + len * (4 * i + 2) + 3, 20);
            g.drawString(" " + h + "h " + p + "p " + s + "s", 90, lenY + len * (4 * i + 3) + 3, 20);
        }
        this.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTake;
                if (currentThread != this.gameThread) {
                    g = null;
                    currentThread = null;
                    Runtime.getRuntime().gc();
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown() && this.isPlay) {
                    this.drawScreen(g);
                    Runtime.getRuntime().gc();
                }
                if ((timeTake = System.currentTimeMillis() - startTime) < this.delay) {
                    HighScoreScreen highScoreScreen = this;
                    synchronized (highScoreScreen) {
                        this.wait(this.delay - timeTake);
                        continue;
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

