/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class MenuNextBattle
extends GameCanvas
implements Runnable,
CommandListener,
GoldItem {
    BomMidlet midlet;
    Sprite needleCount;
    Sprite shieldCount;
    Sprite lifeCount;
    Sprite gold;
    Sprite silver;
    Sprite player;
    Sprite[] item = new Sprite[7];
    GameDesign gameDesign = new GameDesign();
    LayerManager lm = new LayerManager();
    int score;
    int time;
    int countNeedle;
    int countShield;
    int countLife;
    boolean haste = false;
    boolean turtle = false;
    int bomLength = 1;
    int bomCount = 1;
    int stage;
    int sizeMode;
    int delay = 100;
    int pX;
    int pY;
    int[] itemPrice = new int[7];
    boolean isPlay = true;
    boolean isCommand = false;
    Command continueCommand = new Command("Menu", 6, 0);
    private Thread gameThread = null;
    int cX;
    int cY;
    boolean isBack = false;
    boolean isContinue = false;
    String note;
    int choice = 0;
    int firePress = 5;
    boolean right = true;

    public MenuNextBattle(BomMidlet midlet, int countNeedle, int countShield, int countLife, int score, int time, int stage, int sizeMode) throws IOException {
        super(false);
        this.midlet = midlet;
        this.init(countNeedle, countShield, countLife, score, time, stage, sizeMode);
        this.initMenu();
        this.lm.append((Layer)this.needleCount);
        this.lm.append((Layer)this.shieldCount);
        this.lm.append((Layer)this.lifeCount);
        this.lm.append((Layer)this.gold);
        this.lm.append((Layer)this.silver);
        this.lm.append((Layer)this.player);
        this.addCommand(this.continueCommand);
        this.setCommandListener(this);
        this.pX = this.item[0].getX();
        this.pY = this.item[0].getY();
        this.cX = this.item[0].getX();
        this.cY = this.item[0].getY() + this.item[0].getHeight();
        this.note = midlet.menuLanguage ? "Press 5 Or Center Key" : "\u1ea4n ph\u00edm 5 ho\u1eb7c ph\u00edm gi\u1eefa";
    }

    public void init(int countNeedle, int countShield, int countLife, int score, int time, int stage, int sizeMode) {
        this.countNeedle = countNeedle;
        this.countShield = countShield;
        this.countLife = countLife;
        this.score = score;
        this.time = time;
        this.stage = stage;
        this.sizeMode = sizeMode;
    }

    public void initMenu() throws IOException {
        this.player = new Sprite(this.gameDesign.getChar124(), 24, 24);
        this.needleCount = new Sprite(this.gameDesign.getItem24(), 20, 24);
        this.needleCount.setFrame(0);
        this.shieldCount = new Sprite(this.gameDesign.getItem24(), 20, 24);
        this.shieldCount.setFrame(1);
        this.lifeCount = new Sprite(this.gameDesign.getChar124(), 24, 24);
        this.lifeCount.setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.gold = new Sprite(this.gameDesign.getMoney(), 20, 20);
        this.silver = new Sprite(this.gameDesign.getMoney(), 20, 20);
        if (this.sizeMode == 2) {
            this.player = new Sprite(this.gameDesign.getChar118(), 18, 18);
            this.needleCount.setImage(this.gameDesign.getItem18(), 14, 18);
            this.shieldCount.setImage(this.gameDesign.getItem18(), 14, 18);
            this.lifeCount.setImage(this.gameDesign.getChar118(), 18, 18);
            this.gold.setImage(this.gameDesign.getMoney18(), 18, 18);
            this.silver.setImage(this.gameDesign.getMoney18(), 18, 18);
        }
        for (int i = 0; i < this.item.length; ++i) {
            this.item[i] = new Sprite(this.gameDesign.getItem24(), 20, 24);
            if (this.sizeMode == 2) {
                this.item[i].setImage(this.gameDesign.getItem18(), 14, 18);
            }
            this.lm.append((Layer)this.item[i]);
        }
        int dx = 0;
        dx = this.sizeMode == 2 ? 30 : 60;
        this.needleCount.setPosition(dx, this.getHeight() / 2 - this.needleCount.getHeight() * 4);
        this.shieldCount.setPosition(this.needleCount.getX() + 2 * this.needleCount.getWidth(), this.needleCount.getY());
        this.lifeCount.setPosition(this.needleCount.getX() + 2 * this.needleCount.getWidth() * 2, this.needleCount.getY());
        this.item[0].setPosition(dx, this.needleCount.getY() + 2 * this.needleCount.getHeight());
        this.item[0].setFrameSequence(this.gameDesign.NEEDLE);
        this.item[1].setPosition(10 + this.item[0].getX() + this.item[0].getWidth(), this.item[0].getY());
        this.item[1].setFrameSequence(this.gameDesign.SHIELD);
        this.item[2].setPosition(20 + this.item[0].getX() + 2 * this.item[0].getWidth(), this.item[0].getY());
        this.item[2].setFrameSequence(this.gameDesign.LIFE);
        this.item[3].setPosition(this.item[0].getX(), this.item[0].getY() + this.item[0].getHeight());
        this.item[3].setFrameSequence(this.gameDesign.DOUBLEBOM);
        this.item[4].setPosition(this.item[1].getX(), this.item[3].getY());
        this.item[4].setFrameSequence(this.gameDesign.TURTLE);
        this.item[5].setPosition(this.item[2].getX(), this.item[3].getY());
        this.item[5].setFrameSequence(this.gameDesign.HASTESHOES);
        this.item[6].setPosition(this.item[0].getX(), this.item[0].getY() + 2 * this.item[0].getHeight());
        this.item[6].setFrameSequence(this.gameDesign.SUPERBOM);
        this.gold.setPosition(this.item[1].getX(), this.item[6].getY());
        this.gold.setFrameSequence(this.gameDesign.MONEYseq001);
        this.silver.setPosition(this.item[2].getX(), this.item[6].getY());
        this.silver.setFrameSequence(this.gameDesign.MONEYseq002);
        this.itemPrice[0] = 1000;
        this.itemPrice[1] = 1200;
        this.itemPrice[2] = 1500;
        this.itemPrice[3] = 100;
        this.itemPrice[4] = 500;
        this.itemPrice[5] = 300;
        this.itemPrice[6] = 200;
        this.player.setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.player.setPosition(this.item[1].getX(), this.item[6].getY() + 2 * this.needleCount.getWidth() + 15);
    }

    public void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTake;
                if (currentThread != this.gameThread) {
                    g = null;
                    currentThread = null;
                    Runtime.getRuntime().gc();
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown() && this.isPlay) {
                    int choice = this.choiceItem();
                    for (int i = 0; i < this.item.length; ++i) {
                        if (i != choice) {
                            this.item[i].setFrame(0);
                            continue;
                        }
                        this.item[i].nextFrame();
                    }
                    this.keyInput();
                    this.playerMoving();
                    this.lifeCount.nextFrame();
                    this.gold.nextFrame();
                    this.silver.nextFrame();
                    this.drawScreen(g);
                    Runtime.getRuntime().gc();
                }
                if ((timeTake = System.currentTimeMillis() - startTime) < (long)this.delay) {
                    MenuNextBattle menuNextBattle = this;
                    synchronized (menuNextBattle) {
                        this.wait((long)this.delay - timeTake);
                        continue;
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyInput() {
        ++this.firePress;
        int keyState = this.getKeyStates();
        if ((keyState & 0x100) != 0 && this.firePress >= 5 && !this.isCommand) {
            this.firePress = 0;
            int choice = this.choiceItem();
            if (choice >= 0) {
                this.buyItem(choice);
            }
            return;
        }
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int gameAction = this.getGameAction(keyCode);
        if (this.isPlay && !this.isCommand) {
            switch (gameAction) {
                case 1: {
                    if (this.pY > this.needleCount.getY() + 2 * this.needleCount.getHeight() + 10) {
                        this.pY -= this.item[0].getHeight();
                    }
                    return;
                }
                case 6: {
                    if (this.pY < this.item[0].getY() + 2 * this.item[0].getHeight()) {
                        this.pY += this.item[0].getHeight();
                    }
                    return;
                }
                case 2: {
                    if (this.pX > this.item[0].getX()) {
                        this.pX -= 10 + this.item[0].getWidth();
                    }
                    return;
                }
                case 5: {
                    if (this.pX < this.item[2].getX()) {
                        this.pX += 10 + this.item[0].getWidth();
                    }
                    return;
                }
            }
        } else if (this.isPlay && this.isCommand) {
            switch (gameAction) {
                case 1: {
                    if (this.cY > this.item[0].getY() + this.item[0].getHeight()) {
                        this.cY -= this.item[0].getHeight();
                    }
                    return;
                }
                case 6: {
                    if (this.cY < this.item[0].getY() + 2 * this.item[0].getHeight()) {
                        this.cY += this.item[0].getHeight();
                    }
                    return;
                }
                case 8: {
                    if (this.cY == this.item[0].getY() + this.item[0].getHeight()) {
                        this.continueGame();
                    } else {
                        this.backGame();
                    }
                    return;
                }
            }
        }
    }

    public void playerMoving() {
        if (this.player.getX() > this.getWidth() * 3 / 4) {
            this.right = false;
            this.player.setFrameSequence(this.gameDesign.CHAR124seqLeft);
            this.lifeCount.setFrameSequence(this.gameDesign.CHAR124seqLeft);
        }
        if (this.player.getX() < this.needleCount.getX()) {
            this.player.setFrameSequence(this.gameDesign.CHAR124seqRight);
            this.right = true;
            this.lifeCount.setFrameSequence(this.gameDesign.CHAR124seqRight);
        }
        if (this.right) {
            this.player.move(5, 0);
        } else {
            this.player.move(-5, 0);
        }
        this.player.nextFrame();
    }

    public int choiceItem() {
        for (int i = 0; i < this.item.length; ++i) {
            if (this.pX != this.item[i].getX() || this.pY != this.item[i].getY()) continue;
            return i;
        }
        if (this.pY == this.gold.getY() && this.pX == this.gold.getX()) {
            return this.item.length;
        }
        if (this.pY == this.silver.getY() && this.pX == this.silver.getX()) {
            return this.item.length + 1;
        }
        return -1;
    }

    public void buyItem(int choice) {
        this.choice = choice;
        if (choice == this.item.length) {
            SendMessageItem sendMI = new SendMessageItem("QQBOOMNEW", "6711", this);
            new Thread(sendMI).start();
            return;
        }
        if (choice == this.item.length + 1) {
            SendMessageItem sendMI = new SendMessageItem("QQBOOMNEW", "6611", this);
            new Thread(sendMI).start();
            return;
        }
        if (this.score >= this.itemPrice[choice] && this.item[choice].isVisible()) {
            this.score -= this.itemPrice[choice];
            switch (choice) {
                case 0: {
                    ++this.countNeedle;
                    break;
                }
                case 1: {
                    ++this.countShield;
                    break;
                }
                case 3: {
                    if (!this.item[3].isVisible()) break;
                    this.bomCount = 2;
                    this.item[3].setVisible(false);
                    break;
                }
                case 4: {
                    if (!this.item[4].isVisible()) break;
                    this.turtle = true;
                    this.item[4].setVisible(false);
                    break;
                }
                case 5: {
                    if (!this.item[5].isVisible()) break;
                    this.haste = true;
                    this.item[5].setVisible(false);
                    break;
                }
                case 6: {
                    if (!this.item[6].isVisible()) break;
                    this.bomLength = 2;
                    this.item[6].setVisible(false);
                    break;
                }
                case 2: {
                    ++this.countLife;
                }
            }
        }
    }

    public void clean() {
        this.isPlay = false;
        this.needleCount = null;
        this.shieldCount = null;
        this.lifeCount = null;
        this.gold = null;
        this.silver = null;
        this.player = null;
        this.item = null;
        this.gameDesign = null;
        this.lm = null;
        this.itemPrice = null;
        this.removeCommand(this.continueCommand);
        this.continueCommand = null;
        this.gameThread = null;
        this.note = null;
        Runtime.getRuntime().gc();
    }

    private void continueGame() {
        try {
            Graphics g = this.getGraphics();
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 0, 0);
            g.setFont(Font.getFont((int)64, (int)1, (int)0));
            g.drawString("NOW LOADING...", this.getWidth() / 2, this.getHeight() / 2, 17);
            this.flushGraphics();
            g = null;
            this.clean();
            Score scoreData = new Score("BOOM");
            scoreData.loadScores();
            scoreData.saveStage(this.stage, this.score, this.time, this.countLife, this.countNeedle, this.countShield);
            scoreData = null;
            Runtime.getRuntime().gc();
            Thread.sleep(5000L);
            BomGamePractice gameCanvas = new BomGamePractice(this.midlet, this.stage + 1, this.score, this.time, this.countLife, this.countNeedle, this.countShield, this.bomCount, this.bomLength, this.turtle, this.haste, this.sizeMode);
            gameCanvas.start();
            this.midlet.display.setCurrent((Displayable)gameCanvas);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void backGame() {
        try {
            Graphics g = this.getGraphics();
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 0, 0);
            g.setFont(Font.getFont((int)64, (int)1, (int)16));
            g.drawString("NOW LOADING...", this.getWidth() / 2, this.getHeight() / 2, 17);
            this.flushGraphics();
            g = null;
            this.clean();
            Score scoreData = new Score("BOOM");
            scoreData.loadScores();
            scoreData.saveStage(this.stage, this.score, this.time, this.countLife, this.countNeedle, this.countShield);
            scoreData = null;
            Runtime.getRuntime().gc();
            Thread.sleep(3000L);
            this.midlet.display.setCurrent((Displayable)new SunnetCanvas(this.midlet));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.continueCommand) {
            this.isCommand = !this.isCommand;
        }
    }

    private void drawScreen(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.lm.paint(g, 0, 0);
        Font font = null;
        if (this.sizeMode == 1) {
            font = Font.getFont((int)32, (int)0, (int)16);
        } else if (this.sizeMode == 2) {
            font = Font.getFont((int)0, (int)0, (int)8);
        }
        g.setFont(font);
        g.setColor(255, 255, 255);
        g.drawRect(this.pX, this.pY, this.needleCount.getWidth(), this.needleCount.getHeight());
        g.setColor(0, 255, 0);
        int h = this.time / 3600;
        int p = (this.time - 3600 * h) / 60;
        int s = this.time - 3600 * h - 60 * p;
        g.drawString("  " + this.countNeedle, this.needleCount.getX() + this.needleCount.getWidth(), this.needleCount.getY(), 17);
        g.drawString("  " + this.countShield, this.shieldCount.getX() + this.needleCount.getWidth(), this.shieldCount.getY(), 17);
        g.drawString("  " + this.countLife, this.lifeCount.getX() + this.needleCount.getWidth() + 3, this.lifeCount.getY(), 17);
        g.setColor(255, 242, 0);
        g.setFont(Font.getFont((int)64, (int)1, (int)0));
        if (this.choiceItem() >= 0 && this.choiceItem() < this.item.length) {
            g.drawString("$" + this.score + "-" + this.itemPrice[this.choiceItem()], this.item[1].getX() + this.item[1].getWidth(), this.item[2].getY() - 15, 17);
        } else if (this.choiceItem() == this.item.length) {
            g.drawString("$" + this.score + "+20000", this.item[1].getX() + this.item[1].getWidth(), this.item[2].getY() - 15, 17);
        } else if (this.choiceItem() == this.item.length + 1) {
            g.drawString("$" + this.score + "+5000", this.item[1].getX() + this.item[1].getWidth(), this.item[2].getY() - 15, 17);
        }
        g.setColor(255, 255, 255);
        g.setFont(Font.getFont((int)0, (int)1, (int)16));
        g.drawString("Battle " + String.valueOf(this.stage + 1), this.item[1].getX(), this.player.getY(), 17);
        g.setColor(255, 255, 255);
        g.drawString("S", this.item[0].getX() - this.item[0].getWidth(), this.lifeCount.getY() - 10, 17);
        g.drawString("C", this.item[0].getX() - this.item[0].getWidth(), this.lifeCount.getY() + 15 - 10, 17);
        g.drawString("O", this.item[0].getX() - this.item[0].getWidth(), this.lifeCount.getY() + 30 - 10, 17);
        g.drawString("R", this.item[0].getX() - this.item[0].getWidth(), this.lifeCount.getY() + 45 - 10, 17);
        g.drawString("E", this.item[0].getX() - this.item[0].getWidth(), this.lifeCount.getY() + 60 - 10, 17);
        g.drawString("S", this.item[2].getX() + 2 * this.item[2].getWidth(), this.item[2].getY() + 5, 17);
        g.drawString("C", this.item[2].getX() + 2 * this.item[2].getWidth(), this.item[2].getY() + 20, 17);
        g.drawString("O", this.item[2].getX() + 2 * this.item[2].getWidth(), this.item[2].getY() + 40 - 5, 17);
        g.drawString("R", this.item[2].getX() + 2 * this.item[2].getWidth(), this.item[2].getY() + 55 - 5, 17);
        g.drawString("E", this.item[2].getX() + 2 * this.item[2].getWidth(), this.item[2].getY() + 70 - 5, 17);
        g.setFont(Font.getFont((int)32, (int)0, (int)16));
        g.drawString(" " + h + "h " + p + "p " + s + "s", this.needleCount.getX() + this.needleCount.getWidth() + 10, this.item[6].getY() + this.needleCount.getWidth() + 10, 17);
        if (this.isCommand) {
            g.setColor(0, 0, 0);
            g.fillRect(this.item[0].getX(), this.item[0].getY(), this.item[2].getX() - this.item[0].getX() + this.item[2].getWidth() + 5, this.item[6].getY() - this.item[0].getY() + 2 * this.item[6].getHeight());
            g.setColor(0, 255, 0);
            Font newfont = Font.getFont((int)64, (int)1, (int)0);
            g.setFont(newfont);
            g.drawString("NEXT BATTLE", this.item[0].getX(), this.item[0].getY() + this.item[0].getHeight(), 20);
            g.drawString("BACK MENU", this.item[0].getX(), this.item[0].getY() + 2 * this.item[0].getHeight(), 20);
            g.setFont(Font.getFont((int)64, (int)4, (int)8));
            g.drawString(this.note, this.item[0].getX() - this.item[0].getWidth(), this.item[0].getY() + 3 * this.item[0].getHeight(), 20);
            g.setColor(255, 255, 255);
            g.fillRoundRect(this.cX - this.item[0].getWidth(), this.cY, newfont.getHeight(), newfont.getHeight(), 90, 90);
        }
        this.flushGraphics();
    }

    public void setGold() {
        if (this.choice == this.item.length) {
            this.score += 20000;
            return;
        }
        if (this.choice == this.item.length + 1) {
            this.score += 10000;
            return;
        }
    }
}

