/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStoreException;

public class Score
extends BaseRMS {
    private String[] names = new String[3];
    public int prevStage;
    public int score;
    public int countLife;
    public int countNeedle;
    public int countShield;
    public int timePlay;
    public int[] stage = new int[3];
    public int[] time = new int[3];

    public Score(String rmsName) {
        super(rmsName);
        this.initValues();
        this.prevStage = 0;
        this.score = 500;
        this.timePlay = 0;
        this.countLife = 3;
        this.countNeedle = 1;
        this.countShield = 1;
    }

    private void initValues() {
        this.names[0] = "THIEN";
        this.stage[0] = 3;
        this.time[0] = 300;
        this.names[1] = "HIEN";
        this.stage[1] = 2;
        this.time[1] = 200;
        this.names[2] = "THINH";
        this.stage[2] = 1;
        this.time[2] = 1000;
    }

    public void loadScores() throws Exception {
        try {
            this.open();
            this.loadData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception("Error loading Scores" + e);
        }
    }

    public String[] getNames() {
        return this.names;
    }

    public void reset() throws Exception {
        this.open();
        this.initValues();
        this.updateData();
        if (this.getRecordStore() != null) {
            this.close();
        }
    }

    public void updateScores(int sta, int tim, String name) throws Exception {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                if (sta <= this.stage[i] && (sta != this.stage[i] || tim >= this.time[i])) continue;
                this.open();
                for (int j = this.names.length - 1; j > i; --j) {
                    this.stage[j] = this.stage[j - 1];
                    this.names[j] = this.names[j - 1];
                    this.time[j] = this.time[j - 1];
                }
                this.stage[i] = sta;
                this.names[i] = name;
                this.time[i] = tim;
                this.updateData();
                if (this.getRecordStore() != null) {
                    this.close();
                }
                break;
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::updateScores::" + e);
        }
    }

    public void loadStage() throws Exception {
        try {
            this.open();
            this.loadStageData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::load stage::" + e);
        }
    }

    public void saveStage(int stage, int score, int timePlay, int life, int countNeedle, int countShield) throws Exception {
        try {
            this.open();
            this.prevStage = stage;
            this.score = score;
            this.timePlay = timePlay;
            this.countLife = life;
            this.countNeedle = countNeedle;
            this.countShield = countShield;
            this.saveStageData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "error save stage::" + e);
        }
    }

    public boolean isHighScore(int stag, int tim) throws Exception {
        boolean isHighScore = false;
        try {
            for (int i = 0; i < this.names.length; ++i) {
                if (stag <= this.stage[i] && (stag != this.stage[i] || tim >= this.time[i])) continue;
                isHighScore = true;
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::isHighScore::" + e);
        }
        return isHighScore;
    }

    protected void loadData() throws Exception {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                byte[] record = this.getRecordStore().getRecord(i + 1);
                DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
                this.stage[i] = istream.readInt();
                this.names[i] = istream.readUTF();
                this.time[i] = istream.readInt();
            }
            byte[] record = this.getRecordStore().getRecord(4);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this.prevStage = istream.readInt();
            this.score = istream.readInt();
            this.timePlay = istream.readInt();
            this.countLife = istream.readInt();
            this.countNeedle = istream.readInt();
            this.countShield = istream.readInt();
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::loadData::" + e);
        }
    }

    protected void createDefaultData() throws Exception {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(12);
                DataOutputStream ostream = new DataOutputStream(bstream);
                ostream.writeInt(this.stage[i]);
                ostream.writeUTF(this.names[i]);
                ostream.writeInt(this.time[i]);
                ostream.flush();
                ostream.close();
                byte[] record = bstream.toByteArray();
                this.getRecordStore().addRecord(record, 0, record.length);
            }
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(24);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.prevStage);
            ostream.writeInt(this.score);
            ostream.writeInt(this.timePlay);
            ostream.writeInt(this.countLife);
            ostream.writeInt(this.countNeedle);
            ostream.writeInt(this.countShield);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().addRecord(record, 0, record.length);
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::createDefaultData::" + e);
        }
    }

    protected void updateData() throws Exception {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(12);
                DataOutputStream ostream = new DataOutputStream(bstream);
                ostream.writeInt(this.stage[i]);
                ostream.writeUTF(this.names[i]);
                ostream.writeInt(this.time[i]);
                ostream.flush();
                ostream.close();
                byte[] record = bstream.toByteArray();
                this.getRecordStore().setRecord(i + 1, record, 0, record.length);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::updateData::" + e);
        }
    }

    protected void saveStageData() throws Exception {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(24);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.prevStage);
            ostream.writeInt(this.score);
            ostream.writeInt(this.timePlay);
            ostream.writeInt(this.countLife);
            ostream.writeInt(this.countNeedle);
            ostream.writeInt(this.countShield);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().setRecord(4, record, 0, record.length);
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::save stage data::" + e);
        }
    }

    protected void loadStageData() throws IOException {
        try {
            byte[] record = this.getRecordStore().getRecord(4);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this.prevStage = istream.readInt();
            this.score = istream.readInt();
            this.timePlay = istream.readInt();
            this.countLife = istream.readInt();
            this.countNeedle = istream.readInt();
            this.countShield = istream.readInt();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }
}

