/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

class SmartEnemy
extends Character {
    Vector smartEnemy;
    int stage;
    byte[][] itemMatrix;
    boolean follow = false;

    public SmartEnemy(GameDesign gameDesign, byte[][] matrix, byte[][] floor, byte[][] itemMatrix, LayerManager lm, TiledLayer map, Vector character, Vector smartEnemy, int stage, int dx, int dy, int sizeMode) throws IOException {
        this.matrix = matrix;
        this.floor = floor;
        this.map = map;
        this.itemMatrix = itemMatrix;
        this.lm = lm;
        this.gameDesign = gameDesign;
        this.character = character;
        this.smartEnemy = smartEnemy;
        this.stage = stage;
        this.sizeMode = sizeMode;
        this.bomVector = new Vector();
        this.feetMove = 24;
        this.sprite = new Sprite(gameDesign.getChar224(), this.feetMove, this.feetMove);
        this.turtle = new Sprite(gameDesign.getChar224(), 24, 24);
        if (sizeMode == 2) {
            this.feetMove = 18;
            this.sprite.setImage(gameDesign.getChar218(), 18, 18);
            this.turtle.setImage(gameDesign.getChar218(), 18, 18);
        }
        this.sprite.setPosition(dx * this.feetMove, dy * this.feetMove);
        this.sprite.setFrameSequence(gameDesign.CHAR224seqUp);
        this.direct = 4;
        this.turtle.setVisible(false);
        if (stage > 4) {
            this.sizeFeet = 4;
        }
        if (stage > 7) {
            this.bomLength = 2;
        }
        if (stage > 18) {
            this.bomCount = 2;
        }
        lm.append((Layer)this.turtle);
        lm.append((Layer)this.sprite);
    }

    public boolean AvoidBomRight(int length) {
        int row = this.sprite.getY() / this.feetMove;
        int column = this.sprite.getX() / this.feetMove;
        for (int i = 0; i <= length; ++i) {
            int j;
            if (column + i + 1 < this.sizeMatrix && this.matrix[row][column + i + 1] == this.floor[row][column + i + 1]) {
                for (j = 0; j <= i && (this.matrix[row][column + j] == 0 || this.matrix[row][column + j] == this.floor[row][column + j]); ++j) {
                    if (j != i) continue;
                    return false;
                }
            }
            if (row + i < this.sizeMatrix && this.matrix[row + i][column + 1] == this.floor[row + i][column + 1]) {
                for (j = 0; j < i && (this.matrix[row + j][column + 1] == 0 || this.matrix[row + j][column + 1] == this.floor[row + j][column + 1]); ++j) {
                    if (j != i - 1) continue;
                    return false;
                }
            }
            if (row - i < 0 || this.matrix[row - i][column + 1] != this.floor[row - i][column + 1]) continue;
            for (j = 0; j < i && (this.matrix[row - j][column + 1] == 0 || this.matrix[row - j][column + 1] == this.floor[row - j][column + 1]); ++j) {
                if (j != i - 1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean AvoidBomLeft(int length) {
        int row = this.sprite.getY() / this.feetMove;
        int column = this.sprite.getX() / this.feetMove;
        for (int i = 0; i <= length; ++i) {
            int j;
            if (column - i - 1 >= 0 && this.matrix[row][column - i - 1] == this.floor[row][column - i - 1]) {
                for (j = 0; j <= i && (this.matrix[row][column - j] == 0 || this.matrix[row][column - j] == this.floor[row][column - j]); ++j) {
                    if (j != i) continue;
                    return false;
                }
            }
            if (row + i < this.sizeMatrix && this.matrix[row + i][column - 1] == this.floor[row + i][column - 1]) {
                for (j = 0; j < i && (this.matrix[row + j][column - 1] == 0 || this.matrix[row + j][column - 1] == this.floor[row + j][column - 1]); ++j) {
                    if (j != i - 1) continue;
                    return false;
                }
            }
            if (row - i < 0 || this.matrix[row - i][column - 1] != this.floor[row - i][column - 1]) continue;
            for (j = 0; j < i && (this.matrix[row - j][column - 1] == 0 || this.matrix[row - j][column - 1] == this.floor[row - j][column - 1]); ++j) {
                if (j != i - 1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean AvoidBomUp(int length) {
        int row = this.sprite.getY() / this.feetMove;
        int column = this.sprite.getX() / this.feetMove;
        for (int i = 0; i <= length; ++i) {
            int j;
            if (row - i - 1 >= 0 && this.matrix[row - i - 1][column] == this.floor[row - i - 1][column]) {
                for (j = 0; j <= i && (this.matrix[row - j][column] == 0 || this.matrix[row - j][column] == this.floor[row - j][column]); ++j) {
                    if (j != i) continue;
                    return false;
                }
            }
            if (column + i < this.sizeMatrix && this.matrix[row - 1][column + i] == this.floor[row - 1][column + i]) {
                for (j = 0; j < i && (this.matrix[row - 1][column + j] == 0 || this.matrix[row - 1][column + j] == this.floor[row - 1][column + j]); ++j) {
                    if (j != i - 1) continue;
                    return false;
                }
            }
            if (column - i < 0 || this.matrix[row - 1][column - i] != this.floor[row - 1][column - i]) continue;
            for (j = 0; j < i && (this.matrix[row - 1][column - j] == 0 || this.matrix[row - 1][column - j] == this.floor[row - 1][column - j]); ++j) {
                if (j != i - 1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean AvoidBomDown(int length) {
        int row = this.sprite.getY() / this.feetMove;
        int column = this.sprite.getX() / this.feetMove;
        for (int i = 0; i <= length; ++i) {
            int j;
            if (row + i + 1 < this.sizeMatrix && this.matrix[row + i + 1][column] == this.floor[row + i + 1][column]) {
                for (j = 0; j <= i && (this.matrix[row + j][column] == 0 || this.matrix[row + j][column] == this.floor[row + j][column]); ++j) {
                    if (j != i) continue;
                    return false;
                }
            }
            if (column + i < this.sizeMatrix && this.matrix[row + 1][column + i] == this.floor[row + 1][column + i]) {
                for (j = 0; j < i && (this.matrix[row + 1][column + j] == 0 || this.matrix[row + 1][column + j] == this.floor[row + 1][column + j]); ++j) {
                    if (j != i - 1) continue;
                    return false;
                }
            }
            if (column - i < 0 || this.matrix[row + 1][column - i] != this.floor[row + 1][column - i]) continue;
            for (j = 0; j < i && (this.matrix[row + 1][column - j] == 0 || this.matrix[row + 1][column - j] == this.floor[row + 1][column - j]); ++j) {
                if (j != i - 1) continue;
                return false;
            }
        }
        return true;
    }

    public void thinkToSetBom(int cas) throws IOException {
        int row = this.sprite.getY() / this.feetMove;
        int column = this.sprite.getX() / this.feetMove;
        if (this.fire && this.setBom) {
            switch (cas) {
                case 1: {
                    if (this.moveUp || this.moveRight || this.moveDown) break;
                    for (int i = 0; i < this.actionBom.length; ++i) {
                        if (this.matrix[row + 1][column] != this.actionBom[i] && this.matrix[row][column + 1] != this.actionBom[i] && this.matrix[row - 1][column] != this.actionBom[i]) continue;
                        this.setBom();
                        this.setBom = false;
                        return;
                    }
                    break;
                }
                case 2: {
                    if (this.moveDown || this.moveLeft || this.moveRight) break;
                    for (int i = 0; i < this.actionBom.length; ++i) {
                        if (this.matrix[row][column - 1] != this.actionBom[i] && this.matrix[row + 1][column] != this.actionBom[i] && this.matrix[row][column + 1] != this.actionBom[i]) continue;
                        this.setBom();
                        this.setBom = false;
                        return;
                    }
                    break;
                }
                case 3: {
                    if (this.moveLeft || this.moveUp || this.moveDown) break;
                    for (int i = 0; i < this.actionBom.length; ++i) {
                        if (this.matrix[row - 1][column] != this.actionBom[i] && this.matrix[row][column - 1] != this.actionBom[i] && this.matrix[row + 1][column] != this.actionBom[i]) continue;
                        this.setBom();
                        this.setBom = false;
                        return;
                    }
                    break;
                }
                case 4: {
                    if (this.moveUp || this.moveLeft || this.moveRight) break;
                    for (int i = 0; i < this.actionBom.length; ++i) {
                        if (this.matrix[row][column + 1] != this.actionBom[i] && this.matrix[row - 1][column] != this.actionBom[i] && this.matrix[row][column - 1] != this.actionBom[i]) continue;
                        this.setBom();
                        this.setBom = false;
                        return;
                    }
                    break;
                }
            }
        }
    }

    public void vsPlayerRight(MainPlayer player) throws IOException {
        int rowCom = this.sprite.getY() / this.feetMove;
        int columnCom = this.sprite.getX() / this.feetMove;
        int rowPlayer = player.sprite.getY() / this.feetMove;
        int columnPlayer = player.sprite.getX() / this.feetMove;
        if (rowCom == rowPlayer) {
            if ((columnCom + 1 == columnPlayer || columnCom - 1 == columnPlayer || columnCom == columnPlayer) && this.fire) {
                this.setBom();
                return;
            }
        } else if ((rowCom - 1 == rowPlayer || rowCom + 1 == rowPlayer || rowCom == rowPlayer) && columnCom == columnPlayer && this.fire) {
            this.setBom();
            return;
        }
    }

    public void setState(int state) {
        switch (state) {
            case 1: {
                if (!this.turtle.isVisible()) {
                    this.sprite.setFrameSequence(this.gameDesign.CHAR224seqRight);
                    break;
                }
                this.sprite.setFrameSequence(this.gameDesign.HORSE224Right);
                this.turtle.setFrameSequence(this.gameDesign.CHAR224seqRight);
                break;
            }
            case 2: {
                if (!this.turtle.isVisible()) {
                    this.sprite.setFrameSequence(this.gameDesign.CHAR224seqDown);
                    break;
                }
                this.sprite.setFrameSequence(this.gameDesign.HORSE224Down);
                this.turtle.setFrameSequence(this.gameDesign.CHAR224seqDown);
                break;
            }
            case 3: {
                if (!this.turtle.isVisible()) {
                    this.sprite.setFrameSequence(this.gameDesign.CHAR224seqLeft);
                    break;
                }
                this.sprite.setFrameSequence(this.gameDesign.HORSE224Left);
                this.turtle.setFrameSequence(this.gameDesign.CHAR224seqLeft);
                break;
            }
            case 4: {
                if (!this.turtle.isVisible()) {
                    this.sprite.setFrameSequence(this.gameDesign.CHAR224seqUp);
                    break;
                }
                this.sprite.setFrameSequence(this.gameDesign.HORSE224Up);
                this.turtle.setFrameSequence(this.gameDesign.CHAR224seqUp);
            }
        }
    }

    public void directChoice(MainPlayer player) throws IOException {
        this.isMoveCharacter();
        if (this.haste && this.stillGoDown == 0 && this.stillGoLeft == 0 && this.stillGoUp == 0 && this.stillGoRight == 0) {
            this.sizeFeet = 4;
        }
        if (this.isMove && this.alive == 0) {
            if (this.direct == 4) {
                this.thinkToSetBom(4);
                if (this.moveRight && this.AvoidBomRight(this.bomLength) && this.AvoidBomRight(player.bomLength)) {
                    this.direct = 1;
                    return;
                }
                if (!(this.moveUp && this.AvoidBomUp(this.bomLength) && this.AvoidBomUp(player.bomLength))) {
                    if (this.moveLeft && this.AvoidBomLeft(this.bomLength) && this.AvoidBomLeft(player.bomLength)) {
                        this.direct = 3;
                        return;
                    }
                    if (this.moveDown && this.AvoidBomDown(this.bomLength) && this.AvoidBomDown(player.bomLength)) {
                        this.direct = 2;
                        return;
                    }
                    if (this.moveRight) {
                        this.direct = 1;
                        return;
                    }
                }
            } else if (this.direct == 3) {
                this.thinkToSetBom(3);
                if (this.moveUp && this.AvoidBomUp(this.bomLength) && this.AvoidBomUp(player.bomLength)) {
                    this.direct = 4;
                    return;
                }
                if (!(this.moveLeft && this.AvoidBomLeft(this.bomLength) && this.AvoidBomLeft(player.bomLength))) {
                    if (this.moveDown && this.AvoidBomDown(this.bomLength) && this.AvoidBomDown(player.bomLength)) {
                        this.direct = 2;
                        return;
                    }
                    if (this.moveRight && this.AvoidBomRight(this.bomLength) && this.AvoidBomRight(player.bomLength)) {
                        this.direct = 1;
                        return;
                    }
                    if (this.moveUp) {
                        this.direct = 4;
                        return;
                    }
                }
            } else if (this.direct == 2) {
                this.thinkToSetBom(2);
                if (this.moveLeft && this.AvoidBomLeft(this.bomLength) && this.AvoidBomLeft(player.bomLength)) {
                    this.direct = 3;
                    return;
                }
                if (!(this.moveDown && this.AvoidBomDown(this.bomLength) && this.AvoidBomDown(player.bomLength))) {
                    if (this.moveRight && this.AvoidBomRight(this.bomLength) && this.AvoidBomRight(player.bomLength)) {
                        this.direct = 1;
                        return;
                    }
                    if (this.moveUp && this.AvoidBomUp(this.bomLength) && this.AvoidBomUp(player.bomLength)) {
                        this.direct = 4;
                        return;
                    }
                    if (this.moveLeft) {
                        this.direct = 3;
                        return;
                    }
                }
            } else if (this.direct == 1) {
                this.thinkToSetBom(1);
                if (this.moveDown && this.AvoidBomDown(this.bomLength) && this.AvoidBomDown(player.bomLength)) {
                    this.direct = 2;
                    return;
                }
                if (!(this.moveRight && this.AvoidBomRight(this.bomLength) && this.AvoidBomRight(player.bomLength))) {
                    if (this.moveUp && this.AvoidBomUp(this.bomLength) && this.AvoidBomUp(player.bomLength)) {
                        this.direct = 4;
                        return;
                    }
                    if (this.moveLeft && this.AvoidBomLeft(this.bomLength) && this.AvoidBomLeft(player.bomLength)) {
                        this.direct = 3;
                        return;
                    }
                    if (this.moveDown) {
                        this.direct = 2;
                        return;
                    }
                }
            }
        }
    }

    public void keyInputCom(MainPlayer mainPlayer) {
        Random ran;
        if (!this.follow && (ran = new Random()).nextInt(100) < 10) {
            this.direct = ran.nextInt(4) + 1;
        }
        if (this.isMove && this.alive == 0) {
            if (this.direct == 1) {
                this.setState(1);
                if (this.moveRight) {
                    this.goRight();
                    return;
                }
            } else if (this.direct == 2) {
                this.setState(2);
                if (this.moveDown) {
                    this.goDown();
                    return;
                }
            } else if (this.direct == 3) {
                this.setState(3);
                if (this.moveLeft) {
                    this.goLeft();
                    return;
                }
            } else if (this.direct == 4) {
                this.setState(4);
                if (this.moveUp) {
                    this.goUp();
                    return;
                }
            }
        }
    }

    public void getItem() {
        int dx = this.sprite.getX() / this.feetMove;
        int dy = this.sprite.getY() / this.feetMove;
        if (this.itemMatrix[dy][dx + 1] == 1 || this.itemMatrix[dy + 1][dx + 1] == 1) {
            this.direct = 4;
            return;
        }
        if (this.itemMatrix[dy][dx - 1] == 1 || this.itemMatrix[dy - 1][dx - 1] == 1) {
            this.direct = 2;
            return;
        }
        if (this.itemMatrix[dy + 1][dx] == 1 || this.itemMatrix[dy + 1][dx - 1] == 1) {
            this.direct = 1;
            return;
        }
        if (this.itemMatrix[dy - 1][dx] == 1 || this.itemMatrix[dy - 1][dx - 1] == 1) {
            this.direct = 3;
            return;
        }
    }

    public void followPlayer(MainPlayer mainPlayer) {
        int dx = this.sprite.getX() / this.feetMove;
        int dy = this.sprite.getY() / this.feetMove;
        int dx1 = mainPlayer.sprite.getX() / this.feetMove;
        int dy1 = mainPlayer.sprite.getY() / this.feetMove;
        if (dy == dy1 && dx + 1 == dx1 || dy + 1 == dy1 && dx + 1 == dx1) {
            this.follow = true;
            this.direct = 4;
            return;
        }
        if (dy == dy1 && dx - 1 == dx1 || dy - 1 == dy1 && dx - 1 == dx1) {
            this.follow = true;
            this.direct = 2;
            return;
        }
        if (dy + 1 == dy1 && dx == dx1 || dy + 1 == dy1 && dx - 1 == dx1) {
            this.follow = true;
            this.direct = 1;
            return;
        }
        if (dy - 1 == dy1 && dx == dx1 || dy - 1 == dy1 && dx - 1 == dx1) {
            this.follow = true;
            this.direct = 3;
            return;
        }
        this.follow = false;
    }

    public void smartAction(MainPlayer player) throws IOException {
        this.stateDead();
        if (!this.dieState) {
            this.bomAction(player);
            this.followPlayer(player);
            this.getItem();
            this.directChoice(player);
            this.keyInputCom(player);
            this.isNotMovedCharater();
            this.vsPlayerRight(player);
            ++this.fireBom;
            this.moveDown = true;
            this.moveLeft = true;
            this.moveRight = true;
            this.moveUp = true;
        }
        if (this.dieState) {
            this.sprite.nextFrame();
            for (int l = 0; l < this.bomVector.size(); ++l) {
                Character.Bom bom = (Character.Bom)this.bomVector.elementAt(l);
                this.lm.remove((Layer)bom.bom);
                for (int m = 0; m < bom.bomDestroyVector.size(); ++m) {
                    Sprite destroy = (Sprite)bom.bomDestroyVector.elementAt(m);
                    this.lm.remove((Layer)destroy);
                    bom.bomDestroyVector.removeElementAt(m);
                    --m;
                }
                this.matrix[bom.bom.getY() / this.feetMove][bom.bom.getX() / this.feetMove] = 0;
                this.bomVector.removeElementAt(l);
                --l;
            }
        }
        if (this.turtle.isVisible()) {
            this.turtle.setPosition(this.sprite.getX(), this.sprite.getY() - 10);
        }
    }
}

