/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

class Snake
extends Character {
    Vector snake;
    int dx;
    int dy;
    int stage;
    int timeReborn = 0;

    public Snake(GameDesign gameDesign, byte[][] matrix, LayerManager lm, TiledLayer map, int stage, int dx, int dy, Vector snake, int sizeMode) throws IOException {
        this.matrix = matrix;
        this.map = map;
        this.horse = false;
        this.gameDesign = gameDesign;
        this.lm = lm;
        this.snake = snake;
        this.sizeMode = sizeMode;
        this.sizeFeet = 6;
        this.stage = stage;
        this.isSnake = true;
        this.feetMove = 24;
        this.sprite = new Sprite(gameDesign.getSnake24(), this.feetMove, this.feetMove);
        if (sizeMode == 2) {
            this.feetMove = 18;
            this.sprite.setImage(gameDesign.getSnake18(), 18, 18);
        }
        if (stage > 18) {
            this.sizeFeet = 4;
        }
        this.dx = dx;
        this.dy = dy;
        this.sprite.setPosition(dx * this.feetMove, dy * this.feetMove);
        this.sprite.setFrameSequence(gameDesign.SNAKE24seqUp);
        this.direct = 4;
        lm.append((Layer)this.sprite);
    }

    public void snakeCollides(MainPlayer player) {
        if (this.sprite.collidesWith(player.sprite, true) && this.alive == 0) {
            if (player.shield.isVisible()) {
                player.shield.setVisible(false);
            }
            if (player.turtle.isVisible()) {
                player.turtle.setVisible(false);
                if (player.direct == 1) {
                    player.sprite.setFrameSequence(this.gameDesign.CHAR124seqRight);
                } else if (player.direct == 2) {
                    player.sprite.setFrameSequence(this.gameDesign.CHAR124seqDown);
                } else if (player.direct == 3) {
                    player.sprite.setFrameSequence(this.gameDesign.CHAR124seqLeft);
                } else if (player.direct == 4) {
                    player.sprite.setFrameSequence(this.gameDesign.CHAR124seqUp);
                }
            }
            if (player.alive == 0) {
                player.sprite.setFrameSequence(this.gameDesign.CHAR124seqLose);
                player.isMove = false;
                player.alive = 21;
                ++this.alive;
            }
        }
    }

    public void directChoice() {
        this.isMoveCharacter();
        if (this.isMove && this.alive == 0) {
            if (this.direct == 4) {
                if (this.moveRight) {
                    this.direct = 1;
                    return;
                }
                if (!this.moveUp) {
                    this.direct = 3;
                    return;
                }
            } else if (this.direct == 3) {
                if (this.moveUp) {
                    this.direct = 4;
                    return;
                }
                if (!this.moveLeft) {
                    this.direct = 2;
                    return;
                }
            } else if (this.direct == 2) {
                if (this.moveLeft) {
                    this.direct = 3;
                    return;
                }
                if (!this.moveDown) {
                    this.direct = 1;
                    return;
                }
            } else if (this.direct == 1) {
                if (this.moveDown) {
                    this.direct = 2;
                    return;
                }
                if (!this.moveRight) {
                    this.direct = 4;
                    return;
                }
            }
        }
    }

    public void keyInputCom() {
        Random ran = new Random();
        if (ran.nextInt(20) < 3) {
            this.direct = ran.nextInt(4) + 1;
        }
        if (this.haste && this.stillGoDown == 0 && this.stillGoLeft == 0 && this.stillGoRight == 0 && this.stillGoUp == 0) {
            this.sizeFeet = 4;
        }
        if (this.isMove && this.alive == 0) {
            if (this.direct == 1) {
                this.sprite.setFrameSequence(this.gameDesign.SNAKE24seqRight);
                if (this.moveRight) {
                    this.goRight();
                }
            } else if (this.direct == 2) {
                this.sprite.setFrameSequence(this.gameDesign.SNAKE24seqDown);
                if (this.moveDown) {
                    this.goDown();
                }
            } else if (this.direct == 4) {
                this.sprite.setFrameSequence(this.gameDesign.SNAKE24seqUp);
                if (this.moveUp) {
                    this.goUp();
                }
            } else if (this.direct == 3) {
                this.sprite.setFrameSequence(this.gameDesign.SNAKE24seqLeft);
                if (this.moveLeft) {
                    this.goLeft();
                }
            }
        }
        this.moveDown = true;
        this.moveLeft = true;
        this.moveRight = true;
        this.moveUp = true;
    }

    public void reBorn() {
        if (this.alive > 9) {
            ++this.timeReborn;
            this.sprite.setVisible(false);
        }
        if (this.timeReborn > 50) {
            this.timeReborn = 0;
            this.sizeFeet = 6;
            this.haste = false;
            this.alive = 0;
            this.isMove = true;
            this.dieState = false;
            this.stillGoUp = 0;
            this.stillGoLeft = 0;
            this.stillGoRight = 0;
            this.stillGoDown = 0;
            this.sprite.setVisible(true);
            this.sprite.setPosition(this.dx * this.feetMove, this.dy * this.feetMove);
            this.sprite.setFrameSequence(this.gameDesign.SNAKE24seqUp);
            this.direct = 4;
        }
    }

    public void snakeAction(MainPlayer player) {
        if (!this.dieState) {
            this.directChoice();
            this.keyInputCom();
            this.isNotMovedCharater();
            this.snakeCollides(player);
        }
        this.stateDead();
        if (this.dieState) {
            this.sprite.nextFrame();
        }
        this.reBorn();
    }
}

