/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class YourInfo
extends BaseRMS {
    int money = 700;

    public YourInfo(String str) {
        super(str);
    }

    public void loadInfo() throws Exception {
        try {
            this.open();
            this.loadData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception("Error loading Scores" + e);
        }
    }

    public void updateInfo(int money) throws Exception {
        this.open();
        this.money = money;
        this.updateData();
        if (this.getRecordStore() != null) {
            this.close();
        }
    }

    void loadData() throws Exception {
        try {
            byte[] record = this.getRecordStore().getRecord(1);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this.money = istream.readInt();
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::loadData::" + e);
        }
    }

    void createDefaultData() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(4);
        DataOutputStream ostream = new DataOutputStream(bstream);
        ostream.writeInt(this.money);
        ostream.flush();
        ostream.close();
        byte[] record = bstream.toByteArray();
        this.getRecordStore().addRecord(record, 0, record.length);
    }

    void updateData() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(4);
        DataOutputStream ostream = new DataOutputStream(bstream);
        ostream.writeInt(this.money);
        ostream.flush();
        ostream.close();
        byte[] record = bstream.toByteArray();
        this.getRecordStore().setRecord(1, record, 0, record.length);
    }
}

