/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

class GameObject {
    public Sprite mainSprite;
    public Sprite[] gunSprite;
    public int preType = 0;
    public int type;
    public int strength;
    public int[] strengthGun;
    public int ObjectX;
    public int ObjectY;
    public boolean free = false;
    public SkyWar midlet;
    public int aspect = 0;
    public boolean inScreen = false;
    public int gunNum = 0;
    public int[] aspectX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public int[] aspectY = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    public int frameTime = 0;
    public int fireTime = 0;
    public int step = 0;
    public boolean scope = false;

    public GameObject(Sprite sprite, int type, int strength) {
        this.mainSprite = sprite;
        this.type = type;
        this.strength = strength;
        this.free = false;
    }

    public void extendInit() {
        Sprite sprite = null;
        Sprite sprite1 = null;
        int i = 0;
        int k = 0;
        this.inScreen = false;
        switch (this.type) {
            case -3: {
                this.gunNum = 3;
                break;
            }
            case -2: {
                this.gunNum = 5;
                sprite = this.midlet.gameCanvas.gun2;
                break;
            }
            case -1: {
                this.gunNum = 3;
                sprite = this.midlet.gameCanvas.gun1;
                sprite1 = this.midlet.gameCanvas.gun2;
                break;
            }
            case 0: {
                this.gunNum = 0;
                break;
            }
            case 1: {
                this.gunNum = 0;
                break;
            }
            case 2: {
                this.gunNum = 0;
                break;
            }
            case 3: {
                this.gunNum = 0;
                break;
            }
            case 4: {
                this.gunNum = 0;
                break;
            }
            case 5: {
                this.gunNum = 1;
                sprite = this.midlet.gameCanvas.gun2;
                break;
            }
            case 6: {
                this.gunNum = 1;
                sprite = this.midlet.gameCanvas.gun1;
                break;
            }
            case 7: {
                this.gunNum = 1;
                sprite = this.midlet.gameCanvas.gun2;
                break;
            }
            case 8: {
                this.gunNum = 0;
                break;
            }
            case 9: {
                this.gunNum = 2;
                sprite = this.midlet.gameCanvas.gun2;
                break;
            }
            case 10: {
                this.gunNum = 0;
            }
        }
        if (this.gunSprite != null) {
            this.gunSprite = null;
        }
        if (this.strengthGun != null) {
            this.strengthGun = null;
        }
        if (this.gunNum > 0) {
            this.gunSprite = new Sprite[this.gunNum];
            this.strengthGun = new int[this.gunNum];
            k = this.strength / this.gunNum;
        }
        if (this.type >= 0 && sprite != null) {
            for (i = 0; i < this.gunSprite.length; ++i) {
                this.gunSprite[i] = new Sprite(sprite);
                this.strengthGun[i] = k;
                this.strength -= k;
            }
        }
        switch (this.type) {
            case -3: {
                for (i = 0; i < this.gunNum; ++i) {
                    this.strengthGun[i] = this.strength / this.gunNum;
                }
                this.gunSprite[0] = this.midlet.gameCanvas.leftGun;
                this.gunSprite[1] = this.midlet.gameCanvas.middleGun;
                this.gunSprite[2] = this.midlet.gameCanvas.rightGun;
                this.strength = 0;
                break;
            }
            case -2: {
                for (i = 0; i < this.gunNum; ++i) {
                    this.gunSprite[i] = new Sprite(sprite);
                    this.strengthGun[i] = this.strength / this.gunNum;
                }
                this.strength = 0;
                break;
            }
            case -1: {
                this.gunSprite[0] = new Sprite(sprite);
                this.gunSprite[1] = new Sprite(sprite1);
                this.gunSprite[2] = new Sprite(sprite1);
                this.strengthGun[0] = this.strength / 2;
                this.strengthGun[1] = this.strength / 4;
                this.strengthGun[2] = this.strength / 4;
                this.strength = 0;
            }
        }
    }

    public void append(SkyWar midlet) {
        this.midlet = midlet;
    }

    public int getSpeed() {
        int result = 0;
        switch (this.type) {
            case 1: 
            case 2: {
                result = 5;
            }
        }
        if (this.screenWidth() <= 200) {
            result = 3;
        }
        return result;
    }

    private int screenWidth() {
        return this.midlet.gameCanvas.screenWidth;
    }

    private int screenHeight() {
        return this.midlet.gameCanvas.screenHeight;
    }

    private int screenX() {
        return this.midlet.gameCanvas.screenX;
    }

    private int screenY() {
        return this.midlet.gameCanvas.screenY;
    }

    private int viewWidth() {
        return this.midlet.gameCanvas.ViewWidth;
    }

    private int viewHeight() {
        return this.midlet.gameCanvas.ViewHeight;
    }

    public void tickPlayer() {
        if (this.type != 100) {
            ++this.frameTime;
            if (this.frameTime == 2) {
                boolean visible = this.midlet.gameCanvas.fireTail.isVisible();
                this.midlet.gameCanvas.fireTail.setVisible(!visible);
                this.frameTime = 0;
            }
            if (this.midlet.gameCanvas.autoFire) {
                ++this.fireTime;
                if (this.fireTime == 5) {
                    this.fireTime = 0;
                    if (!this.midlet.gameCanvas.doubleShoot) {
                        this.midlet.gameCanvas.buildBullet(0, 0, true, 0, this);
                    } else {
                        this.midlet.gameCanvas.buildBullet(0, 1, true, 0, this);
                    }
                }
            }
        } else {
            ++this.frameTime;
            if (this.midlet.gameCanvas.stepLaser >= 0) {
                for (int i = 0; i < this.midlet.gameCanvas.Laser.length && this.midlet.gameCanvas.Laser[i] != null; ++i) {
                    this.midlet.gameCanvas.layerManager.remove((Layer)this.midlet.gameCanvas.Laser[i]);
                    this.midlet.gameCanvas.Laser[i] = null;
                    this.midlet.gameCanvas.layer[0] = this.midlet.gameCanvas.layer[0] - 1;
                }
                this.midlet.gameCanvas.stepLaser = -1;
            }
            if (this.frameTime == 8) {
                this.frameTime = 0;
                this.mainSprite.setVisible(true);
                this.midlet.gameCanvas.fireTail.setVisible(true);
                int x = this.screenX() + this.viewWidth() / 2 - this.mainSprite.getWidth() / 2;
                int y = this.screenY() + this.viewHeight() - this.mainSprite.getHeight();
                this.mainSprite.setPosition(x, y);
                switch (this.midlet.gameCanvas.playerType) {
                    case 0: {
                        this.strength = 9;
                        break;
                    }
                    case 1: {
                        this.strength = 12;
                        break;
                    }
                    case 2: {
                        this.strength = 15;
                    }
                }
                this.ObjectX = x;
                this.ObjectY = y;
                this.type = 0;
            }
        }
    }

    public void tickSmallPlane(int position) {
        if (this.type != 100) {
            switch (position) {
                case 1: {
                    this.tickPlane1();
                    break;
                }
                case 2: {
                    this.tickPlane2();
                    break;
                }
                case 3: {
                    this.tickPlane3();
                    break;
                }
                case 4: {
                    this.tickPlane4();
                    break;
                }
                case 5: {
                    this.tickPlane5();
                    break;
                }
                case 6: {
                    this.tickPlane6();
                }
            }
        } else {
            this.midlet.gameCanvas.layer[1] = this.midlet.gameCanvas.layer[1] - 1;
            --this.midlet.gameCanvas.numSmallPlane;
            this.midlet.gameCanvas.layerManager.remove((Layer)this.mainSprite);
            this.free = true;
        }
    }

    private void tickPlane1() {
        int speed = this.getSpeed();
        this.aspect = 1;
        this.ObjectX += speed * this.aspectX[this.aspect];
        this.ObjectY += speed * this.aspectY[this.aspect];
        this.mainSprite.setFrame(this.aspect);
    }

    private void tickPlane2() {
        int speed = this.getSpeed();
        this.aspect = 3;
        this.ObjectX += speed * this.aspectX[this.aspect];
        this.ObjectY += speed * this.aspectY[this.aspect];
        this.mainSprite.setFrame(this.aspect);
    }

    private void tickPlane3() {
        int speed = this.getSpeed();
        int width = this.mainSprite.getWidth();
        int height = this.mainSprite.getHeight();
        if (this.step == 0) {
            this.aspect = 2;
            if (this.ObjectY >= this.screenY() + this.viewHeight() / (2 * speed) * speed) {
                this.step = 1;
                this.aspect = 1;
                this.frameTime = 0;
            }
        } else if (this.step == 1) {
            ++this.frameTime;
            if (this.frameTime == 2) {
                this.step = 2;
                this.aspect = 0;
                this.frameTime = 0;
            }
        } else if (this.step == 2) {
            ++this.frameTime;
            if (this.frameTime == 2) {
                this.step = 3;
                this.aspect = 7;
                this.frameTime = 0;
            }
        }
        this.ObjectX += this.aspectX[this.aspect] * speed;
        this.ObjectY += this.aspectY[this.aspect] * speed;
        this.mainSprite.setFrame(this.aspect);
    }

    private void tickPlane4() {
        int speed = this.getSpeed();
        int width = this.mainSprite.getWidth();
        int height = this.mainSprite.getHeight();
        if (this.step == 0) {
            this.aspect = 2;
            if (this.ObjectY >= this.screenY() + this.viewHeight() / (2 * speed) * speed) {
                this.step = 1;
                this.aspect = 3;
                this.frameTime = 0;
            }
        } else if (this.step == 1) {
            ++this.frameTime;
            if (this.frameTime == 2) {
                this.step = 2;
                this.aspect = 4;
                this.frameTime = 0;
            }
        } else if (this.step == 2) {
            ++this.frameTime;
            if (this.frameTime == 2) {
                this.step = 3;
                this.aspect = 5;
                this.frameTime = 0;
            }
        }
        this.ObjectX += this.aspectX[this.aspect] * speed;
        this.ObjectY += this.aspectY[this.aspect] * speed;
        this.mainSprite.setFrame(this.aspect);
    }

    private void tickPlane5() {
        int speed = this.getSpeed();
        int width = this.mainSprite.getWidth();
        int height = this.mainSprite.getHeight();
        if (this.step == 0) {
            if (this.frameTime == 0) {
                this.aspect = 7;
                if (this.ObjectX >= this.screenX() + (this.viewWidth() / 2 - width) / speed * speed) {
                    this.step = 1;
                    this.aspect = 6;
                    this.fireTime = 0;
                }
            } else {
                this.aspect = 5;
                if (this.ObjectX <= this.screenX() + this.viewWidth() / (2 * speed) * speed) {
                    this.step = 1;
                    this.aspect = 6;
                    this.fireTime = 0;
                }
            }
        } else if (this.step == 1) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.step = 2;
                this.fireTime = 0;
                this.aspect = this.frameTime == 0 ? 5 : 7;
            }
        } else if (this.step == 2) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.step = 3;
                this.fireTime = 0;
                this.aspect = this.frameTime == 0 ? 4 : 0;
            }
        } else if (this.step == 3) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.step = 4;
                this.fireTime = 0;
                this.aspect = this.frameTime == 0 ? 3 : 1;
            }
        } else if (this.step == 4) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.step = 5;
                this.fireTime = 0;
                this.aspect = 2;
            }
        } else if (this.step == 5) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.step = 6;
                this.fireTime = 0;
                this.aspect = this.frameTime == 0 ? 1 : 3;
            }
        }
        this.ObjectX += this.aspectX[this.aspect] * speed;
        this.ObjectY += this.aspectY[this.aspect] * speed;
        this.mainSprite.setFrame(this.aspect);
    }

    private void tickPlane6() {
        int speed = this.getSpeed();
        int width = this.viewWidth();
        int height = this.viewHeight();
        if (this.step == 0) {
            if (this.frameTime == 0) {
                this.aspect = 1;
                if (this.ObjectX >= this.screenX() + width / 4 + width / (2 * speed) * speed) {
                    this.fireTime = 0;
                    this.aspect = 2;
                    this.step = 1;
                }
            } else {
                this.aspect = 3;
                if (this.ObjectX <= this.screenX() + 3 * width / 4 - width / (2 * speed) * speed) {
                    this.fireTime = 0;
                    this.aspect = 2;
                    this.step = 1;
                }
            }
        } else if (this.step == 1) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.fireTime = 0;
                this.step = 2;
            }
        } else if (this.step == 2) {
            ++this.fireTime;
            if (this.frameTime == 0) {
                this.aspect = 3;
                if (this.ObjectX <= this.screenX() + 3 * width / 4 - width / (2 * speed) * speed) {
                    this.fireTime = 0;
                    this.aspect = 2;
                    this.step = 3;
                }
            } else {
                this.aspect = 1;
                if (this.ObjectX >= this.screenX() + width / 4 + width / (2 * speed) * speed) {
                    this.fireTime = 0;
                    this.aspect = 2;
                    this.step = 3;
                }
            }
        } else if (this.step == 3) {
            ++this.fireTime;
            if (this.fireTime == 2) {
                this.fireTime = 0;
                this.step = 0;
            }
        }
        this.ObjectX += this.aspectX[this.aspect] * speed;
        this.ObjectY += this.aspectY[this.aspect] * speed;
        this.mainSprite.setFrame(this.aspect);
    }

    public void tickHelicopter() {
        int speed = 0;
        if (this.type != 100) {
            speed = this.viewWidth() <= 140 ? 1 : 2;
            this.ObjectY += speed;
            ++this.fireTime;
            ++this.frameTime;
            if (this.fireTime == 40) {
                int y;
                this.fireTime = 0;
                int x = this.ObjectX + this.mainSprite.getWidth() / 2;
                if (!this.outofView(x, y = this.ObjectY + this.mainSprite.getHeight() / 2)) {
                    this.midlet.gameCanvas.buildBullet(2, 0, false, 0, this);
                }
            }
            if (this.frameTime == 2) {
                this.mainSprite.nextFrame();
                this.frameTime = 0;
            }
        } else {
            this.midlet.gameCanvas.layer[1] = this.midlet.gameCanvas.layer[1] - 1;
            --this.midlet.gameCanvas.numHelicopter;
            this.midlet.gameCanvas.layerManager.remove((Layer)this.mainSprite);
            this.free = true;
        }
    }

    public void tickMediumPlane() {
        int speed = 0;
        if (this.type != 100) {
            speed = this.screenWidth() <= 200 ? 1 : 2;
            this.ObjectY -= speed;
            ++this.fireTime;
            if (this.fireTime == 30) {
                int y;
                this.fireTime = 0;
                int x = this.ObjectX + this.mainSprite.getWidth() / 2;
                if (!this.outofView(x, y = this.ObjectY + this.mainSprite.getHeight() / 2)) {
                    this.midlet.gameCanvas.buildBullet(1, 0, false, 0, this);
                }
            }
        } else {
            this.midlet.gameCanvas.layer[1] = this.midlet.gameCanvas.layer[1] - 1;
            --this.midlet.gameCanvas.numMediumPlane;
            this.midlet.gameCanvas.layerManager.remove((Layer)this.mainSprite);
            this.free = true;
        }
    }

    public void tickSmallShip() {
        int speed = 2;
        if (this.type != 100) {
            ++this.fireTime;
            if (this.step == 0) {
                if (this.ObjectY - this.screenY() + this.mainSprite.getHeight() > this.viewHeight() / 2) {
                    this.step = 1;
                }
            } else if (this.step == 1) {
                ++this.frameTime;
                this.ObjectX += this.aspectX[this.aspect] * speed;
                this.ObjectY += this.aspectY[this.aspect] * speed;
                if (this.frameTime == 80 && this.aspect == 6) {
                    this.step = 2;
                    this.frameTime = 0;
                }
            }
            if (this.strengthGun[0] > 0) {
                this.turnGun(0);
            }
            if (this.fireTime == 40) {
                this.fireTime = 0;
                int x = this.gunSprite[0].getX() + this.gunSprite[0].getWidth() / 2;
                int y = this.gunSprite[0].getY() + this.gunSprite[0].getHeight() / 2;
                if (this.strengthGun[0] > 0) {
                    this.turnGun(0);
                    this.midlet.gameCanvas.buildBullet(2, 0, false, 0, this);
                }
            }
        } else {
            ++this.frameTime;
            if (this.frameTime == 4) {
                this.frameTime = 0;
                if (this.mainSprite.getFrame() < 1) {
                    this.mainSprite.nextFrame();
                }
            }
        }
    }

    public void tickCanon() {
        if (this.type != 100) {
            ++this.fireTime;
            if (this.fireTime == 5 && this.type == 10) {
                this.midlet.gameCanvas.buildBullet(6, 0, false, 0, this);
                this.fireTime = 0;
            }
            switch (this.type) {
                case 6: {
                    if (this.strengthGun[0] > 0) {
                        this.turnGun(0);
                        int x = this.gunSprite[0].getX() + this.gunSprite[0].getWidth() / 2;
                        int y = this.gunSprite[0].getY() + this.gunSprite[0].getHeight() / 2;
                        if (this.fireTime == 50) {
                            this.midlet.gameCanvas.buildBullet(3, 0, false, 0, this);
                        }
                    }
                    if (this.fireTime != 50) break;
                    this.fireTime = 0;
                    break;
                }
                case 8: {
                    int x = this.ObjectX + this.mainSprite.getWidth() / 2;
                    int y = this.ObjectY + this.mainSprite.getHeight() / 2;
                    if (this.fireTime != 60) break;
                    this.midlet.gameCanvas.buildBullet(4, 7, false, 0, this);
                    this.fireTime = 0;
                    break;
                }
                case 9: {
                    int y;
                    int x;
                    if (this.strengthGun[0] > 0) {
                        this.turnGun(0);
                        x = this.gunSprite[0].getX() + this.gunSprite[0].getWidth() / 2;
                        y = this.gunSprite[0].getY() + this.gunSprite[0].getHeight() / 2;
                        if (this.fireTime == 50) {
                            this.midlet.gameCanvas.buildBullet(5, 1, false, 0, this);
                        }
                    }
                    if (this.strengthGun[1] > 0) {
                        this.turnGun(1);
                        x = this.gunSprite[1].getX() + this.gunSprite[1].getWidth() / 2;
                        y = this.gunSprite[1].getY() + this.gunSprite[1].getHeight() / 2;
                        if (this.fireTime == 50) {
                            this.midlet.gameCanvas.buildBullet(5, 1, false, 1, this);
                        }
                    }
                    if (this.fireTime != 50) break;
                    this.fireTime = 0;
                }
            }
        } else {
            ++this.frameTime;
            if (this.frameTime == 4) {
                this.frameTime = 0;
                if (this.mainSprite.getFrame() < 1 && this.preType == 8) {
                    this.mainSprite.nextFrame();
                }
                if (this.mainSprite.getFrame() < 2 && this.preType == 6) {
                    this.mainSprite.nextFrame();
                }
                if (this.mainSprite.getFrame() < 1 && this.preType == 10) {
                    this.mainSprite.nextFrame();
                }
                if (this.mainSprite.getFrame() < 1 && this.preType == 9) {
                    this.mainSprite.nextFrame();
                }
            }
        }
    }

    private GameObject getPlayer() {
        return this.midlet.gameCanvas.Player;
    }

    private boolean outofView(int x, int y) {
        return x < this.screenX() || x > this.screenX() + this.viewWidth() || y < this.screenY() || y > this.screenY() + this.viewHeight();
    }

    public void tickBossShip() {
        int speed = 2;
        int num = 0;
        if (this.type != 100) {
            ++this.fireTime;
            if (this.step == 0) {
                if (this.ObjectY + this.mainSprite.getHeight() >= this.screenY() + this.viewHeight() / 2) {
                    this.step = 1;
                    this.aspect = 6;
                    this.frameTime = 0;
                }
                if (this.midlet.gameCanvas.isEndMap()) {
                    this.step = 2;
                    this.frameTime = 0;
                    this.aspect = 2;
                }
            } else if (this.step == 1) {
                if (this.ObjectY < this.screenY()) {
                    this.step = 0;
                    this.frameTime = 0;
                }
            } else if (this.step == 2 && this.ObjectY >= this.screenY() + this.viewHeight() / 2) {
                this.step = 3;
                this.frameTime = 0;
            }
            if (this.step == 1 || this.step == 2) {
                this.ObjectX += this.aspectX[this.aspect] * speed;
                this.ObjectY += this.aspectY[this.aspect] * speed;
            }
            if (this.strengthGun[0] > 0) {
                this.turnGun(0);
            }
            if (this.strengthGun[1] > 0) {
                this.turnGun(1);
            }
            if (this.strengthGun[2] > 0) {
                this.turnGun(2);
            }
            if (this.fireTime == 50) {
                this.fireTime = 0;
                if (this.strengthGun[0] > 0) {
                    this.turnGun(0);
                    this.midlet.gameCanvas.buildBullet(3, num += this.midlet.gameCanvas.level, false, 0, this);
                }
                if (this.strengthGun[1] > 0) {
                    this.turnGun(1);
                    this.midlet.gameCanvas.buildBullet(1, num, false, 1, this);
                }
                if (this.strengthGun[2] > 0) {
                    this.turnGun(2);
                    this.midlet.gameCanvas.buildBullet(1, num, false, 2, this);
                }
            }
        } else {
            ++this.frameTime;
            if (this.frameTime == 4) {
                this.frameTime = 0;
                if (this.mainSprite.getFrame() < 1) {
                    this.mainSprite.nextFrame();
                } else {
                    this.midlet.gameCanvas.bossDie = true;
                }
            }
        }
    }

    public void tickTank() {
        int speed = 2;
        if (this.type != 100) {
            ++this.fireTime;
            if (this.aspect != -1) {
                if (this.step == 0) {
                    if (this.aspect != 6 && this.aspect <= 7) {
                        this.ObjectX += this.aspectX[this.aspect] * speed;
                        this.ObjectY += this.aspectY[this.aspect] * speed;
                    }
                    if (this.aspect > 7) {
                        this.ObjectX += this.aspectX[this.aspect - 8] * speed;
                        this.ObjectY += this.aspectY[this.aspect - 8] * speed;
                    }
                    if (this.aspect == 0 && this.ObjectX + this.mainSprite.getWidth() >= this.screenWidth() / 2) {
                        this.step = 1;
                        this.frameTime = 0;
                    } else if (this.aspect == 4 && this.ObjectX <= this.screenWidth() / 2) {
                        this.step = 1;
                        this.frameTime = 0;
                    } else if (this.aspect == 6 && this.ObjectY >= this.screenY() + this.screenHeight() / 2) {
                        this.step = 1;
                        this.frameTime = 0;
                    }
                } else {
                    ++this.frameTime;
                    if (this.aspect == 6 && this.frameTime <= 40) {
                        this.ObjectX += this.aspectX[this.aspect] * speed;
                        this.ObjectY += this.aspectY[this.aspect] * speed;
                    }
                }
            }
            if (this.strengthGun[0] > 0) {
                this.turnGun(0);
            }
            if (this.fireTime == 50) {
                this.fireTime = 0;
                if (this.strengthGun[0] > 0) {
                    this.turnGun(0);
                    this.midlet.gameCanvas.buildBullet(3, 0, false, 0, this);
                }
            }
        } else {
            ++this.frameTime;
            if (this.frameTime == 4) {
                if (this.aspect != 2) {
                    this.frameTime = 0;
                }
                if (this.mainSprite.getFrame() < 1) {
                    this.mainSprite.nextFrame();
                }
            }
        }
    }

    private void turnGun(int i) {
        int x1 = this.gunSprite[i].getX();
        int y1 = this.gunSprite[i].getY();
        int w1 = this.gunSprite[i].getWidth();
        int h1 = this.gunSprite[i].getHeight();
        int x2 = this.getPlayer().ObjectX;
        int y2 = this.getPlayer().ObjectY;
        int w2 = this.getPlayer().mainSprite.getWidth();
        int h2 = this.getPlayer().mainSprite.getHeight();
        int xo = x2 + w2 / 2;
        int yo = y2 + h2 / 2;
        if (yo >= y1 && yo <= y1 + h1 && xo < x1) {
            this.gunSprite[i].setFrame(4);
        } else if (yo < y1 && xo < x1) {
            this.gunSprite[i].setFrame(5);
        } else if (xo >= x1 && xo <= x1 + w1 && yo < y1) {
            this.gunSprite[i].setFrame(6);
        } else if (xo > x1 + w1 && yo < y1) {
            this.gunSprite[i].setFrame(7);
        } else if (xo > x1 + w1 && yo >= y1 && yo <= y1 + h1) {
            this.gunSprite[i].setFrame(0);
        } else if (xo > x1 + w1 && yo > y1 + h1) {
            this.gunSprite[i].setFrame(1);
        } else if (yo > y1 + h1 && xo >= x1 && xo <= x1 + w1) {
            this.gunSprite[i].setFrame(2);
        } else if (xo < x1 && yo > y1 + h1) {
            this.gunSprite[i].setFrame(3);
        } else if (xo <= x1 + w1 / 2) {
            this.gunSprite[i].setFrame(4);
        } else {
            this.gunSprite[i].setFrame(0);
        }
        int k = this.gunSprite[i].getFrame();
        if (!this.scope) {
            this.gunSprite[i].setFrame((k + 1) % 8);
        }
    }

    public void tickBossPlane() {
        int speed = 1;
        int width = this.mainSprite.getWidth();
        int height = this.mainSprite.getHeight();
        int num = this.midlet.gameCanvas.level - 3;
        Random rand = new Random();
        if (this.type != 100) {
            ++this.fireTime;
            if (this.step == 0) {
                if (this.ObjectY >= this.screenY() + this.viewHeight() / 4) {
                    this.step = 1;
                    this.frameTime = 0;
                    this.aspect = 7;
                    this.fireTime = 0;
                }
            } else if (this.step == 1) {
                speed = 2;
                if (this.midlet.gameCanvas.isEndMap()) {
                    this.step = 3;
                    this.frameTime = 0;
                } else if (this.ObjectY < this.screenY()) {
                    this.step = 2;
                    this.aspect = rand.nextInt(3) + 1;
                } else if (this.outofView(this.ObjectX + width / 2, this.ObjectY + height / 2)) {
                    this.aspect = this.ObjectX > this.screenX() + this.viewWidth() / 2 ? 5 : 7;
                } else if (this.aspect == 6) {
                    ++this.frameTime;
                    if (this.frameTime == 40) {
                        this.aspect = rand.nextInt(2) == 1 ? 5 : 7;
                        this.frameTime = 0;
                    }
                } else if (this.aspect == 7 && this.ObjectX + width >= this.screenX() + this.viewWidth()) {
                    if (rand.nextInt(2) == 1) {
                        this.aspect = 6;
                    }
                    this.frameTime = 0;
                } else if (this.aspect == 5 && this.ObjectX <= this.screenX()) {
                    if (rand.nextInt(2) == 1) {
                        this.aspect = 6;
                    }
                    this.frameTime = 0;
                }
            } else if (this.step == 2) {
                speed = 1;
                if (this.ObjectY > this.screenY() + this.viewHeight() / 2) {
                    this.step = 1;
                    this.aspect = 7 - rand.nextInt(3);
                }
            } else if (this.step == 3) {
                speed = 2;
                if (this.ObjectX <= this.screenX()) {
                    switch (rand.nextInt(3)) {
                        case 0: {
                            this.aspect = 7;
                            break;
                        }
                        case 1: {
                            this.aspect = 0;
                            break;
                        }
                        case 2: {
                            this.aspect = 1;
                        }
                    }
                } else if (this.ObjectX + width >= this.screenX() + this.viewWidth()) {
                    this.aspect = rand.nextInt(3) + 3;
                } else if (this.ObjectY <= this.screenY()) {
                    this.aspect = rand.nextInt(3) + 1;
                } else if (this.ObjectY + height >= this.screenY() + 3 * this.viewHeight() / 4) {
                    this.aspect = rand.nextInt(3) + 5;
                }
            }
            if (this.step != 0) {
                this.ObjectX += this.aspectX[this.aspect] * 2;
                this.ObjectY += this.aspectY[this.aspect] * 1;
                if (this.strengthGun[0] > 0) {
                    this.turnGun(0);
                }
                if (this.strengthGun[1] > 0) {
                    this.turnGun(1);
                }
                if (this.strengthGun[2] > 0) {
                    this.turnGun(2);
                }
                if (this.strengthGun[3] > 0) {
                    this.turnGun(3);
                }
                if (this.strengthGun[4] > 0) {
                    this.turnGun(4);
                }
                if (this.fireTime == 40) {
                    this.fireTime = 0;
                    if (this.strengthGun[0] > 0) {
                        this.midlet.gameCanvas.buildBullet(3, num, false, 0, this);
                    }
                    if (this.strengthGun[1] > 0) {
                        this.midlet.gameCanvas.buildBullet(3, num, false, 1, this);
                    }
                    if (this.strengthGun[0] <= 0 && this.strengthGun[1] <= 0) {
                        if (this.strengthGun[2] > 0) {
                            this.midlet.gameCanvas.buildBullet(3, num, false, 2, this);
                        }
                        if (this.strengthGun[3] > 0) {
                            this.midlet.gameCanvas.buildBullet(4, 7, false, 3, this);
                        }
                        if (this.strengthGun[4] > 0) {
                            this.midlet.gameCanvas.buildBullet(3, num, false, 4, this);
                        }
                    }
                }
            }
        } else {
            this.midlet.gameCanvas.bossDie = true;
        }
        rand = null;
    }

    public void tickFortress() {
        int num = 2;
        if (this.type != 100) {
            ++this.frameTime;
            if (this.step == 0) {
                ++this.fireTime;
                if (this.fireTime % 40 == 0) {
                    this.midlet.gameCanvas.buildBullet(4, 7, false, 0, this);
                    this.midlet.gameCanvas.buildBullet(4, 7, false, 2, this);
                }
                if (this.fireTime == 80) {
                    this.midlet.gameCanvas.buildBullet(5, 3, false, 1, this);
                    this.fireTime = 0;
                }
                if (this.frameTime == 200) {
                    this.step = 1;
                    this.fireTime = 99;
                    this.frameTime = 0;
                }
            } else if (this.step == 1) {
                ++this.fireTime;
                if (this.fireTime == 100) {
                    this.fireTime = 0;
                    if (this.strengthGun[0] > 0) {
                        this.midlet.gameCanvas.buildBullet(7, 0, false, 0, this);
                        --num;
                    }
                    if (this.strengthGun[2] > 0) {
                        this.midlet.gameCanvas.buildBullet(7, 0, false, 2, this);
                        --num;
                    }
                    if (this.strengthGun[1] > 0 && num > 0) {
                        this.midlet.gameCanvas.buildBullet(7, 0, false, 1, this);
                    }
                }
                if (this.frameTime == 200) {
                    this.step = 2;
                    this.fireTime = 0;
                    this.frameTime = 0;
                    if (this.midlet.gameCanvas.level == 6) {
                        this.step = 0;
                        this.fireTime = 0;
                        this.frameTime = 0;
                    }
                }
            } else if (this.step == 3) {
                ++this.fireTime;
                if (this.fireTime % 40 == 0) {
                    this.midlet.gameCanvas.buildBullet(4, 7, false, 1, this);
                }
                if (this.fireTime == 100) {
                    this.midlet.gameCanvas.thunder = true;
                    this.fireTime = 0;
                }
                if (this.frameTime == 200) {
                    this.step = 0;
                    this.fireTime = 0;
                    this.frameTime = 0;
                    this.midlet.gameCanvas.thunder = false;
                }
            } else if (this.step == 2) {
                ++this.fireTime;
                if (this.fireTime % 40 == 0) {
                    this.midlet.gameCanvas.buildBullet(4, 7, false, 1, this);
                }
                if (this.fireTime == 80) {
                    this.midlet.gameCanvas.openGate = 40;
                    this.fireTime = 0;
                }
                if (this.frameTime == 200) {
                    this.step = 3;
                    this.fireTime = 99;
                    this.frameTime = 0;
                    if (this.midlet.gameCanvas.level == 7) {
                        this.step = 0;
                        this.fireTime = 0;
                        this.frameTime = 0;
                    }
                }
            }
        } else {
            this.midlet.gameCanvas.bossDie = true;
        }
    }
}

